	var hsi_master = {
		hsi_vue: null,
		hsi_data: null,
		initVue: function(){
			this.hsi_vue = new Vue({
				el: "#hsi_block",
				data:{ program: this.hsi_data},
				methods: {
				parse: function(){
						var hsi = this.program['root']['gp'][0]['stock'][0];
						var output = {'open': hsi['r1'], 'current': hsi['r2'], 'diff': hsi['r2'] - hsi['r1']};
						output['diff'] = output['diff'].toFixed(2);
						return output;
					},
					isPositive: function(){
						var hsi = this.parse();
						return (hsi['diff'] > 0)?'green':'red';
					}
				}
			})
		},
		loadData: function(){
			hm = this;
			var response = function(result){
				var data = JSON.parse(result);
				hm.hsi_data = data;
				if(hm.hsi_vue == null && hm.hsi_data !== null) hm.initVue();
				hm.hsi_vue.program = hm.hsi_data;
			}
			ajax({url:"stock_api.php?action=getHSI",  callback: response });
		}
	}

	var stock_master = {
		stock_json_url: "file/stock.json?1",
		stock_vue: null,
		stock_data: null,
		stock_data_parse: null,
		stock_data_detail: {},
		stock_data_history: {},
		stock_setting: null,
		init: function(){
			this.initSetting();
			this.loadData();
		},
		initSetting: function(){
			var result = ajax({url: this.stock_json_url,method:"get", "sync": true})
			var data = JSON.parse(result);

			// parse the json setting and prepare a raw string for query
			data['list_str'] = "";
			data['stock_list'].forEach((group => {
				group['stock_list'].forEach((stock) => {
					data['list_str'] += stock['stock_num'] + ",";
				})
			}));
			data['owned_stock'].forEach((stock => {
					var t_str = this.parseStockNum(stock['stock_num'], digit=5) + ".HK,";
					if(data['list_str'].indexOf(t_str) == -1){
						data['list_str'] += t_str;	
					}
			}));

			data['list_str'] = data['list_str'].substring(0, data['list_str'].length-1);

			this.stock_setting = data;
		},
		initVue: function(){
			this.stock_vue = new Vue({
				el: "#stock_list_block",
				data:{ program: this.stock_data_parse},
				methods: {
					parseSMA_Val: function(mode, stock_num, stock_current){
						var num = stock_master.parseStockNum(stock_num, digit = 0);
						var d = stock_master.stock_data_detail[num] ;
						if(d !== undefined){
							var sma = d['overlays']['sma' + mode];
							sma = sma[sma.length-1]
							var diff = stock_current - sma; diff= diff.toFixed(2);
							return {val: sma, diff: diff};
						}

						return {val: "-", diff: 0};
					},
					parseSMA_Class: function(mode, stock_num, stock_current){
						var result = this.parseSMA_Val(mode, stock_num, stock_current);
						if(result['val'] == "-") return "black";
						else if(result['diff'] > 0) return "green";
						else if(result['diff'] < 0) return "red";
					},
					parseSMA: function(mode, stock_num, stock_current){
						var result = this.parseSMA_Val(mode, stock_num, stock_current);

						if(result['val'] == "-") return "-";
						else return result['val'].toString() + ' (' + result['diff'] + ')'
					},
					parseHistory: function(stock_num){
						var num = stock_master.parseStockNum(stock_num, digit = 0);
						var d = stock_master.stock_data_history[num] ;
						if(d !== undefined){
							var group = d[0];
							// return {val: d[0]['td2'], diff: d[0]['td3']};
							return d[0]['td2'] + " (" + d[0]['td3'] + ")";
						}

						return "-"

						// return {val: "-", diff: 0};
					},
					parseStockNum: function(stock_num, digit = 0){
						return stock_master.parseStockNum(stock_num, digit);
					},

					isPositive: function(diff){
						var cl = "";
						if(diff>0) cl = "green";
						else if(diff<0) cl = "red";
						return cl;
					}
				}
			})
		},
		getParsedStock:function(stock_num){
			var sm = this;
			var parse_data = this.stock_data_parse;

			var matched_stock = {};
			parse_data.forEach((group) => {
				group['stock_list'].forEach((stock) => {
					// console.log(group['group_name']);
					// console.log(sm.parseStockNum(stock['stock_num']) + ':' + stock_num);
					if(sm.parseStockNum(stock['stock_num']) == stock_num){
						matched_stock = stock;
					}
				})
			});

			return matched_stock;
		},

		parseData: function(){
			// parse data
			var stock_list = this.stock_data['root']['gp'][0]['stock'];
			// console.log(stock_list);
			var output = [];
			stock_list.forEach((row) => {
				var return_row = {};
				return_row['stock_num']        = row['s1'];
				return_row['stock_name']       = row['s2'];
				return_row['current']          = row['r2'];
				return_row['high']             = row['r4'];
				return_row['low']              = row['r5'];
				return_row['open']             = row['r1'];
				return_row['dividend_precent'] = row['s12'] / row['r2'] * 100;
				return_row['dividend_raw'] = row['r118'];
				return_row['diff']             = row['r2'] - row['r1'];
				return_row['low_history']      = row['r132'];
				return_row['diff_precent']     = return_row['diff']/return_row['open'] * 100;

				return_row['diff_precent'] = return_row['diff_precent'].toFixed(2);
				return_row['dividend_precent'] = return_row['dividend_precent'].toFixed(2);
				return_row['diff']             = return_row['diff'].toFixed(2);

				
				output.push(return_row);
			});

			// group data based on setting
			// console.log(output);
			var parsed_output = [];
			this.stock_setting['stock_list'].forEach((group) => {
				var group_name = group['group_name'];
				var list = [];
				group['stock_list'].forEach((stock) => {
					output.forEach((o_stock) => {
						if(stock['stock_num'] == o_stock['stock_num']){
							list.push(o_stock);
						}
					})
				})
				parsed_output.push({'group_name': group_name, 'stock_list': list});
			});

			this.stock_data_parse = parsed_output;
			console.log(parsed_output);
		},
		// stock_master.loadDataDetailAll()
		// Object.keys(stock_master.stock_data_detail).length
		loadDataDetailAll: function(){
			var sm = stock_master;
			var keepLoad = false;
			var stock_list = sm.stock_setting['list_str'].split(',');
			var index = Object.keys(stock_master.stock_data_detail).length;
			
			// console.log(sm.stock_data_parse.length);
			console.log(stock_list.length + '|' + index);
			if(sm.stock_data == null || sm.stock_data_parse == null) keepLoad = true;
			else if(stock_list.length !== index) keepLoad = true;
			
			console.log(sm.parseStockNum(stock_list[index]));
			sm.loadDataDetail(sm.parseStockNum(stock_list[index]));
		

			if(keepLoad){
				setTimeout(sm.loadDataDetailAll, 2 * 1000, this);
			}
			
		},
		loadDataDetail: function(stock_num){
			sm = this;

			if(this.stock_data_detail[stock_num] !== undefined) return;
			var response = function(result){
				var data = JSON.parse(result);
				sm.stock_data_detail[stock_num] = data;
			}
			ajax({url: "stock_api.php", 'post_data': 'action=getStockNow&stock_num=' + stock_num, 'callback': response});

			response = function(result){
				var data = JSON.parse(result);
				sm.stock_data_history[stock_num] = data;
			}
			ajax({url: "stock_api.php", 'post_data': 'action=getStockHistory&stock_num=' + stock_num, 'callback': response});
		},
		loadData: function(){
			sm = this;
			var response = function(result){
				var data = JSON.parse(result);
				sm.stock_data = data;
				sm.parseData();
				if(sm.stock_vue == null && sm.stock_data !== null) sm.initVue();
				sm.stock_vue.program = sm.stock_data_parse;
			}
			ajax({url: "stock_api.php", 'post_data': 'action=getStockList&stock_list=' + this.stock_setting['list_str'], 'callback': response})
			
		},
		parseStockNum: function(stock_num, digit){
			var output = stock_num.replace('.HK');
			output = parseInt(stock_num);

			var placehold = "";
			if(digit !== 0){
				// console.log('placehold' + output.toString().length);
				for(var i=digit-output.toString().length;i>0;i--) placehold += "0";
			}
			return placehold + output.toString();
		}

	}