<head>
	<title>股票追蹤-</title>
</head>

<script type="text/javascript" src="lib.js"></script>
<script src="https://cdn.jsdelivr.net/npm/vue/dist/vue.js"></script>
<script type="text/javascript" src="lib/stock_lib2.js"></script>

<script>
	function setIsSortMode(mode){
		stock_master.isSort = mode; // "sort_by_high"
	}

	function toggleDisplayMode(){
		if(stock_master.display_mode == "general") stock_master.display_mode = "dividend";
		else stock_master.display_mode = "general";
	}
</script>

<div id="hsi_block" :set="hsi = parse()" :class="isPositive()">
	HSI.HK {{hsi['current']}}  
	<span >
		   {{hsi['diff']}}
	</span>
	<input type="button" id="toogleModeBtn" onclick="general_manager.toggleMode()" value="start" />
	<input type="button" id="toogleShowLowRsiBtn" onclick="stock_master.toggleLowRsiMode()" value="Hide Low Dividend" />
	<input type="button" id="toogleShowLowRsiBtn" onclick="stock_master.toggleSortMode()" value="Sort Low" />
	<input type="button" id="toogleShowLowRsiBtn" onclick="setIsSortMode('sort_by_high')" value="Sort High" />
	<input type="button" id="toogleShowLowRsiBtn" onclick="setIsSortMode('sort_by_rsi')" value="Sort RSI" />
	<input type="button" id="toogleShowLowRsiBtn" onclick="setIsSortMode('sort_by_diff_precent')" value="Sort Diff" />
	<input type="button" id="toogleShowLowRsiBtn" onclick="setIsSortMode('sort_by_30_low')" value="30日低" />
	<input type="button" id="toogleShowLowRsiBtn" onclick="setIsSortMode('sort_by_90_low')" value="90日低" />
	<input type="button" id="toogleShowLowRsiBtn" onclick="setIsSortMode('sort_by_bollinger_low')" value="保低" />
	<input type="button" id="toogleShowLowRsiBtn" onclick="toggleDisplayMode()" value="Display Mode" />
</div>


<div id="stock_list_block">
	<div id="group_wrapper" v-for="st in computedRows">
		<div id="wrapper">
			<div id="column" class="left">低價</div>
			<div id="column" class="middle">%</div>
			<div id="column" class="left">stock_num</div>
			<div id="column" class="middle">stock_name</div>
			<div id="column" class="middle">current</div>
			<div id="column" class="middle">diff</div>
			<div id="column" class="left">low</div>
			<div id="column" class="left">open</div>
			<div id="column" class="left">high</div>
			<div id="column" class="left">dividend%</div>
			<div v-if="is_show('general')" id="column" class="middle">SMA 10</div>
			<div v-if="is_show('general')" id="column" class="middle">SMA 20</div>
			<div v-if="is_show('general')" id="column" class="middle">SMA 250</div>
			<div v-if="is_show('general')" id="column" class="left">年低</div>
			<div v-if="is_show('general')" id="column" class="left">3月低</div>
			<div v-if="is_show('general')" id="column" class="left">1月低</div>
			<div v-if="is_show('general')" id="column" class="left">1月高</div>
			<div v-if="is_show('general')" id="column" class="left">年高</div>
			<div v-if="is_show('general')" id="column" class="left">RSI 10</div>
			<div v-if="is_show('general')" id="column" class="left">RSI 14</div>
			<div v-if="is_show('general')" id="column" class="left">保+</div>
			<div v-if="is_show('general')" id="column" class="left">保-</div>
			<div v-if="is_show('dividend')" id="column" class="left">Cutoff</div>
			<div v-if="is_show('dividend')" id="column" class="left">Receive</div>
			<div v-if="is_show('dividend')" id="column" class="left">Type</div>
			<div v-if="is_show('dividend')" id="column" class="left large_flex">Detail</div>

			<div id="column" class="left">Link</div>
		</div>
		<div id="wrapper" v-for="row in st['stock_list']" :class="isPositive(row['diff']) + ' ' + isHidden(row['stock_num'])">
			<div id="column">{{row['low_history']}} </div>
			<div id="column">
				{{
					(row['current'] / parsePerformance("365", "low", row['stock_num'])).toFixed(2)
				}}
				-
				{{
					(parsePerformance("365", "high", row['stock_num']) / row['current']).toFixed(2)
				}}
			</div>
			<div id="column" class="left">
				<a class="stock_name_link" target="_blank" :href="'/stock/sell.php?stock_num=' + parseStockNum(row['stock_num']) ">{{row['stock_num']}}</a>
			</div>
			<div id="column" class="left">
				<a class="stock_name_link" target="_blank" :href="'/page/stock_detail_vue.php?stock_num=' + parseStockNum(row['stock_num'], 5) ">{{row['stock_name']}}</a>
			</div>
			<div id="column" class="right">
				<a class="stock_name_link" target="_blank" :href="'/stock/stock_history_aastock.php?stock_num=' + parseStockNum(row['stock_num'], 4) ">{{row['current']}}</a>
			</div>
			<div id="column" class="right">{{row['diff']}} ({{row['diff_precent']}}%)</div>
			<div id="column" class="right">{{row['low']}}</div>
			<div id="column" class="right">{{row['open']}}</div>
			<div id="column" class="right">{{row['high']}}</div>
			<div id="column" class="right">
				<a class="stock_name_link" target="_blank" :href="'https://content.etnet.com.hk/content/iq/compinfo/tc/quote_dividend.php?code=' + parseStockNum(row['stock_num'], 4) ">
				{{row['dividend_precent']}}
				</a>
			</div>
			<div v-if="is_show('general')" id="column" class="right" :class="parseSMA_Class('10', row['stock_num'], row['current'])">{{parseSMA("10", row['stock_num'], row['current'])}}</div>
			<div v-if="is_show('general')" id="column" class="right" :class="parseSMA_Class('20', row['stock_num'], row['current'])">{{parseSMA("20", row['stock_num'], row['current'])}}</div>
			<div v-if="is_show('general')" id="column" class="right" :class="parseSMA_Class('250', row['stock_num'], row['current'])">{{parseSMA("250", row['stock_num'], row['current'])}}</div>
			<div v-if="is_show('general')" id="column">{{parsePerformance("365", "low", row['stock_num'])}}</div>
			<div v-if="is_show('general')" id="column">{{parsePerformance("90", "low", row['stock_num'])}}</div>
			<div v-if="is_show('general')" id="column">{{parsePerformance("30", "low", row['stock_num'])}}</div>
			<div v-if="is_show('general')" id="column">{{parsePerformance("30", "high", row['stock_num'])}}</div>
			<div v-if="is_show('general')" id="column">{{parsePerformance("365", "high", row['stock_num'])}}</div>
			<div v-if="is_show('general')" id="column" class="right" :class="parseRSI_Class('10', row['stock_num'], row['current'])">{{parseRSI("10", row['stock_num'], row['current'])}}</div>
			<div v-if="is_show('general')" id="column" class="right" :class="parseRSI_Class('14', row['stock_num'], row['current'])">{{parseRSI("14", row['stock_num'], row['current'])}}</div>
			<div v-if="is_show('general')" id="column" class="right">{{parseBollinger(row['stock_num'], 'upper')}} ({{(parseBollinger(row['stock_num'], 'upper') / row['current']).toFixed(2)}})</div>
			<div v-if="is_show('general')" id="column" class="right">{{parseBollinger(row['stock_num'], 'lower')}} ({{(row['current'] / parseBollinger(row['stock_num'], 'lower')).toFixed(2)}})</div>
			<div v-if="is_show('dividend')" id="column" class="right">{{parseDividend(row['stock_num'], 'cutoff_date')}}</div>
			<div v-if="is_show('dividend')" id="column" class="right">{{parseDividend(row['stock_num'], 'receive_date')}}</div>
			<div v-if="is_show('dividend')" id="column" class="right">{{parseDividend(row['stock_num'], 'dividend_type')}}</div>
			<div v-if="is_show('dividend')" id="column" class="left large_flex">{{parseDividend(row['stock_num'], 'dividend_detail')}}</div>
			<div id="column">
				<a target="_blank" :href="'https://stock360.hkej.com/quotePlus/' + parseStockNum(row['stock_num'])">360</a>
				<a target="_blank" :href="'https://hk.finance.yahoo.com/quote/' + parseStockNum(row['stock_num'], 4) + '.HK/'">Yahoo</a>
			</div>

		</div>
	</div>
</div>

<style type="text/css">
/*	#stock_list_block{ display:flex;  }*/
	#stock_list_block #wrapper{ display:flex; width: 100%; }
	#stock_list_block #column { flex: 1;  }
	#stock_list_block #wrapper div:nth-child(1) { flex: 0.6;  }
	#stock_list_block #wrapper div:nth-child(2) { flex: 1.4;  }
	#stock_list_block #wrapper div:nth-child(3) { flex: 1.5;  }
	#stock_list_block #wrapper div:nth-child(4) { flex: 2;  }
	#stock_list_block #wrapper div:nth-child(5) { flex: 1;  }
	#stock_list_block #wrapper div:nth-child(6) { flex: 2;  }
	#stock_list_block #wrapper div:nth-child(7) { flex: 1;  }
	#stock_list_block #wrapper div:nth-child(8) { flex: 1;  }
	#stock_list_block #wrapper div:nth-child(9) { flex: 1;  }
	#stock_list_block #wrapper div:nth-child(10) { flex: 1;  }
	#stock_list_block #wrapper div:nth-child(11) { flex: 2;  }
	#stock_list_block #wrapper div:nth-child(12) { flex: 2;  }
	#stock_list_block #wrapper div:nth-child(13) { flex: 2;  }
	#stock_list_block #wrapper div:nth-child(14) { flex: 1;  }
	#stock_list_block #wrapper div:nth-child(15) { flex: 1;  }
	#stock_list_block #wrapper div:nth-child(16) { flex: 1;  }
	#stock_list_block #wrapper div:nth-child(17) { flex: 1;  }
	#stock_list_block #wrapper div:nth-child(18) { flex: 1;  }
	#stock_list_block #wrapper div:nth-child(19) { flex: 1;  }
	#stock_list_block #wrapper div:nth-child(20) { flex: 1;  }
	#stock_list_block #wrapper div:nth-child(21) { flex: 1.5;  }
	#stock_list_block #wrapper div:nth-child(22) { flex: 1.5;  }
/*	#stock_list_block #wrapper div:nth-child(13) { flex: 4;  }*/
	#stock_list_block #wrapper div:last-child { flex: 1.5;  }

	#stock_list_block #wrapper div.large_flex{ flex: 7.0 }

	div#wrapper:hover{
		background-color: #eeeeee;
	}

	@media only screen and (max-width: 1200px) {
		input[type=button]{
			font-size: 35px;
			padding: 10px;
		}
		body{
			font-size: 35px;
		}

		#hsi_block{
			font-size: 50px;
			width: 3000px;
		}

	  	#stock_list_block #wrapper{ display:flex; width: 4000px; }
		#stock_list_block #column { flex: 1;  }
		
		#stock_list_block #wrapper div:nth-child(1),
		#stock_list_block #wrapper div:nth-child(11) 
		, #stock_list_block #wrapper div:nth-child(12) 
		, #stock_list_block #wrapper div:nth-child(20) 
		, #stock_list_block #wrapper div:nth-child(21) 
			{ display: none  }
	}
</style>

<script type="text/javascript">
	var hsi_vue;
	var general_manager = {
		mode: "start", // start, stop
		toggleMode: function(){
			if(this.mode == "start") this.mode = "stop";
			else this.mode = "start";

			document.querySelector('#toogleModeBtn').value = this.mode;
		}
	}


	function getManager(){
		// getHSI();
		if(general_manager.mode == "start"){
			hsi_master.loadData();
			stock_master.loadData();
		}
		setTimeout(getManager, 4 * 1000);
	}


	function init(){
		var j = readUrlParam().get('json');
		var title = document.title;
		if(j !== null){
			if(j=="dividend_month"){
				stock_master.stock_json_url = "../stock/stock_json_dividend_month.php"; 
			}else if(j=="own"){
				stock_master.stock_json_url = "../stock/stock_json.php"; 	
				title += 'Own';
			}else if(j=="sold"){
				stock_master.stock_json_url = "../stock/stock_json.php?sold_only=true"; 	
				title += 'Sold';
			}else if(j=="all"){
				stock_master.stock_json_url = "file/stock.php"; 	
				title += '全部';
			}else{
				stock_master.stock_json_url = "file/stock" + j + ".json"; 
				title += j;
			}

			document.title = title;
		// if(j == "2"){ 
			// stock_master.stock_json_url = "file/stock2.json"; 
		// }
		}
		stock_master.init();
		getManager();

		<?
			if(isset($_REQUEST['mode'])) echo "setIsSortMode('".$_REQUEST['mode']."')";
		?>
	}
	init();
</script>


<style>
.green{ color: green }
.red{ color: red }
.black { color: black; }

a.stock_name_link{ color: black; text-decoration: none; }

.green  a.stock_name_link{ color: green; text-decoration: none; }
.red  a.stock_name_link{ color: red; text-decoration: none; }


.left{ text-align: left } 
.middle{ text-align: center } 
.right{ text-align: right; padding-right: 20px}

.stock_name{ width: 150px }
.current{ width: 100px }

.hidden { display:none !important;}


</style>
