<meta http-equiv="cache-control" content="no-cache"/>
<script type="text/javascript" src="lib.js"></script>
<script src="https://cdn.jsdelivr.net/npm/vue/dist/vue.js"></script>



<div id="hsi_block" :set="hsi = parse()" :class="isPositive()">
	HSI.HK {{hsi['current']}}  
	<span >
		   {{hsi['diff']}}
	</span>
	<input type="button" value="Toggle Sort" onclick="toggleSort();">
	<input type="button" value="Toggle Sort %" onclick="toggleSortPercent('%');">
	<input type="button" value="Toggle Detail" onclick="toggleDetail();">
</div>

<div id="owned_stock_block">
	<div id="detail" class="<?=isset($_REQUEST['hide'])?'hide':'show'?>">
		<div id="wrapper">
			<div id="column">#</div>
			<div id="column">名稱</div>
			<div id="column">購買數量</div>
			<div id="column">實付</div>
			<div id="column">買入價</div>
			<div id="column">實付(計算)</div>
			<div id="column">賣出價</div>
			<div id="column">實收(計算)</div>
			<div id="column">賺蝕</div>
			<div id="column">賺蝕(%)</div>
		</div>
		<div id="wrapper" v-for="row in computedRows" :class="earn_class(row)" @click="clickRow(row)">
			<div id="column">{{row['stock_num']}}</div>
			<div id="column">{{row['stock_info']['stock_name']}}</div>
			<div id="column">{{row['purchase_qty']}}</div>
			<div id="column">{{row['actual_pay']}}</div>
			<div id="column">{{row['purchase_price']}}</div>
			<div id="column">{{purchase_total(row)}}</div>
			<div id="column">{{row['stock_info']['current']}}</div>
			<div id="column">{{sell_totel(row)}}</div>
			<div id="column">{{earn(row)}}</div>
			<div id="column" class="align_right">{{(earn(row,false) / row['actual_pay'] * 100).toFixed(2)}}%</div>
		</div>
	</div>
	<div id="summary_short">
		<div id="wrapper">
			{{get_earn_total()}}
		</div>
	</div>
	<div id="summary">
		<div id="wrapper" v-for="(row) in get_earn_total_by_stock()" >
			<div id="column">{{row[0]}}</div>
			<div id="column">{{row[2].toFixed(2)}}</div>
			<div id="column">{{row[1].toFixed(2)}}</div>
			<div id="column">{{(row[1] + row[2]).toFixed(2)}}</div>
			<div id="column">{{(row[1] / row[2] * 100).toFixed(2) }}</div>
		</div>
	</div>
</div>

<hr/>

<div id="custom_calculator_input_add_row">
	<input type="text" id="stock_price" />
	<input type="text" id="stock_qty" />
	<input type="button" value="Add Row" onclick="custom_calculator_master.add_row()">
	<input type="button" value="Remove Row" onclick="custom_calculator_master.remove_row()">
</div>

<div id="custom_calculator_input_block">
	<div id="wrapper">
		<div id="column">Stock Price</div>
		<div id="column">Stock Qty</div>
		<div id="column">Charge</div>
		<div id="column">Final Amount</div>
	</div>
	<div id="wrapper" v-for="row in program">
		<div id="column"><input type="text" id="stock_price"  :value="row['stock_price']" /></div>
		<div id="column"><input type="text" id="stock_qty"    :value="row['stock_qty']" /></div>
		<div id="column"><input type="text" id="charge"       :value="row['charge']" /></div>
		<div id="column"><input type="text" id="final_amount" :value="row['final_amount']" /></div>
	</div>
</div>

<div id="custom_calculator_output_block">
	<div id="wrapper">
		<div id="column">Stock Price</div>
		<div id="column">Stock Qty</div>
		<div id="column">Amount</div>
		<div id="column">Earn</div>
	</div>
	<div id="wrapper" v-for="(row, index) in program" :index="index">
		<div id="column"><input type="text" id="stock_price"      :value="row['stock_price']"     onchange="custom_calculator_master.edit_output()" /></div>
		<div id="column"><input type="text" id="stock_qty"        :value="row['stock_qty']"       onchange="custom_calculator_master.edit_output()" /></div>
		<div id="column"><input type="text" id="purchase_amount"  :value="row['purchase_amount']" onchange="custom_calculator_master.edit_output()" /></div>
		<div id="column"><input type="text" id="sell_amount"      :value="row['sell_amount']"     onchange="custom_calculator_master.edit_output()" /></div>
		<div id="column"><input type="text" id="earn"             :value="row['earn']"            onchange="custom_calculator_master.edit_output()" /></div>
	</div>
</div>

<input type="button" value="Reset" onclick="custom_calculator_master.reset_input(); custom_calculator_master.reset_output()">


<style type="text/css">
/*	#stock_list_block{ display:flex;  }*/
	#owned_stock_block #wrapper{ display:flex; width: 90%; }
	#owned_stock_block #column { flex: 1;  }
	
	#custom_calculator_input_block #wrapper{ display:flex; width: 90%; }
	#custom_calculator_input_block #column { flex: 1;  }

	#custom_calculator_output_block #wrapper{ display:flex; width: 90%; }
	#custom_calculator_output_block #column { flex: 1;  }

	#wrapper:hover{
		background-color: #eee;
	}
*/


</style>
<script type="text/javascript" src="lib/stock_lib.js"></script>
<script type="text/javascript">

	function toggleDetail(){
		var ele = document.querySelector('#owned_stock_block #detail');
		if(ele.className == "show") ele.className = "hide";
		else ele.className = "show";
	}

	function toggleSort(){
		if(owned_stock_master.is_sort == "False"){
			owned_stock_master.is_sort = "True";
		}else{
			owned_stock_master.is_sort = "False";
		}
		// owned_stock_master.is_sort = !owned_stock_master.is_sort;
		owned_stock_master.loadData();
		console.log(owned_stock_master.is_sort);
	}

	function toggleSortPercent(){
		owned_stock_master.is_sort = "%";
		owned_stock_master.loadData();
	}

	var general_manager = {
		mode: "start", // start, stop
		toggleMode: function(){
			if(this.mode == "start") this.mode = "stop";
			else this.mode = "start";

			document.querySelector('#toogleModeBtn').value = this.mode;
		}
	}
	
	stock_master.init();
	stock_master.loadData();

	var custom_calculator_master = {
		custom_calculator_input_vue: null,
		custom_calculator_output_vue: null,
		in_data: [],
		out_data: [],
		refresh_in_vue: function(){
			if(this.custom_calculator_input_vue == null){
				this.custom_calculator_input_vue = new Vue({
					el: "#custom_calculator_input_block",
					data: { program: this.in_data} 
				})
			}else{
				this.custom_calculator_input_vue.program = this.in_data;
			}
		},
		refresh_out_vue: function(){
			if(this.custom_calculator_output_vue == null){
				this.custom_calculator_output_vue = new Vue({
					el: "#custom_calculator_output_block",
					data: { program: this.out_data} 
				})
			}else{
				this.custom_calculator_output_vue.program = this.out_data;
			}
		},
		reset_input: function(){ this.in_data = []; this.refresh_in_vue(); },
		reset_output: function(){ this.out_data = []; this.refresh_out_vue(); },
		remove_row:function(){
			var data = [];
			var in_data = this.in_data;
			for(var i=0;i<in_data.length-1;i++){
				data.push(in_data[i]);
			}
			this.in_data = data;
			this.refresh_in_vue();
			this.calculate_output();
		},
		add_row: function(){
			var data = {};
			data['purchase_price'] = document.querySelector('#custom_calculator_input_add_row #stock_price').value;
			data['purchase_qty'] = document.querySelector('#custom_calculator_input_add_row #stock_qty').value;

			this.add_input(data);
	
		},
		add_input: function(data){
			// console.log(data);
			// in_data.push(data);
			var input = {};
			input['stock_price'] = data['purchase_price'];
			input['stock_qty'] = data['purchase_qty'];

			
			try{
				input['sell_price'] = parseFloat(data['stock_info']['current']);
			}catch(e){
				input['sell_price'] = 0;	
			}

			var amount = input['stock_price'] * input['stock_qty'];
			input['charge'] = owned_stock_master.calculate_charge(amount);
			input['final_amount'] = amount + input['charge'];

			this.in_data.push(input);
			this.refresh_in_vue();

			this.calculate_output();
		},
		calculate_output: function(){
			this.reset_output();

			var lowest_price = null;
			var total_qty = 0;
			var total_cost = 0.0;
			var in_data = this.in_data;


			in_data.forEach((row) => {
				if(lowest_price == null) lowest_price = row['stock_price'];
				else if(row['stock_price'] < lowest_price) lowest_price = row['stock_price'];
				total_qty += parseInt(row['stock_qty']);
				total_cost += row['final_amount'];
			})

			lowest_price = parseFloat(lowest_price);
			// lowest_price = lowest_price.toFixed(2);

			console.log(lowest_price);
			console.log(total_qty);
			console.log(total_cost);

			// var amount = lowest_price * total_qty;
			// amount -= owned_stock_master.calculate_charge(amount);

			var print_time = 5;
			for(var i=0;i<500;i++){
				lowest_price += 0.01;
				// lowest_price = Math.round(lowest_price, -2);

				// amount = lowest_price * total_qty;
				// amount -= owned_stock_master.calculate_charge(amount);
				

				if(print_time > 0){
					
					// console.log("=====" + print_time);
					// console.log(lowest_price);
					// console.log(total_qty);
					// console.log(amount + ':' + total_cost);
					if(this.add_output(lowest_price, total_qty, total_cost)) print_time--;	
				}				
			}
			this.add_output(this.in_data[0]['sell_price'], total_qty, total_cost, false);

			this.refresh_out_vue();


		},
		add_output: function(lowest_price, total_qty, total_cost, only_add_positive = true){
			var amount = lowest_price * total_qty;
			amount -= owned_stock_master.calculate_charge(amount);

			var row = {};
			row['stock_price'] = lowest_price.toFixed(2);
			row['stock_qty'] = total_qty;
			row['purchase_amount'] = total_cost.toFixed(2);
			row['sell_amount'] = amount.toFixed(2);
			row['earn'] = (amount - total_cost).toFixed(2);

			if(amount > total_cost || !only_add_positive){
				this.out_data.push(row);
				return true;
			}else{
				return false;
			}
		},
		edit_output: function(){
			console.log('start edit');
			var rows = document.querySelectorAll("#custom_calculator_output_block div#wrapper");
			this.out_data = [];
			for(var i=1; i<rows.length;i++){

				var row = rows[i];
				// console.log(row);

				var lowest_price = parseFloat(row.querySelector("#stock_price").value);
				var total_qty = parseInt(row.querySelector("#stock_qty").value);
				var total_cost = parseFloat(row.querySelector("#purchase_amount").value);
				this.add_output(lowest_price, total_qty, total_cost);
			}

			// console.log(this.out_data);

			this.refresh_out_vue();
		},
		edit_input: function(){

		}
	};

	var owned_stock_master = {
		owned_stock_vue: null,
		owned_stock_data: null,
		is_sort: "False",
		earn_total: 0,
		earn_total_pos: 0,
		earn_total_neg:0,
		earn_total_by_stock: {},
		earn_base_by_stock: {},
		initVue: function(){
			this.owned_stock_vue = new Vue({
				el: "#owned_stock_block",
				data:{ program: this.owned_stock_data},
				computed: {
					computedRows() {
						console.log(owned_stock_master.is_sort );
						var list = [...this.program];
						if(owned_stock_master.is_sort == "True"){
							list.sort((a,b) => {
								if(a['stock_num'] < b['stock_num']) return -1;
								if(a['stock_num'] > b['stock_num']) return 1;
								return 0;
							});
						}else if(owned_stock_master.is_sort == "%"){

							console.log("compueted");
							list.sort((a,b) => {
								// if(parseInt(this.earn(a)) > parseInt(this.earn(b))) return -1;

								if(
									(this.earn(a,false) / a['actual_pay'] * 100) > 
									(this.earn(b,false) / b['actual_pay'] * 100)
								) return -1;
								else return 1;
								
							});
						}


						return list;
						// return [...this.program].sort((a, b) => {
						// 	// a[this.sortBy] - b[this.sortBy]
						// 	a['current'] - b['current']
						// 	// (a['current'] / this.parsePerformance("365", "low", a['stock_num'])) - 
						// 	// (b['current'] / this.parsePerformance("365", "low", b['stock_num']))
						// })
					}
				},
				methods: {
					clickRow: function(stock){
						custom_calculator_master.add_input(stock);
					},
					charge: function(amount){
						return owned_stock_master.calculate_charge(amount);
					},
					purchase_total: function(stock){
						var amount = stock['purchase_qty'] * stock['purchase_price'];
						amount += owned_stock_master.calculate_charge(amount);
						return amount.toFixed(2);
					},
					sell_totel: function(stock){
						var amount = stock['purchase_qty'] * stock['stock_info']['current'];
						amount -= owned_stock_master.calculate_charge(amount);
						return amount.toFixed(2);
					},
					earn: function(stock, do_sum=true){
						var amount = this.sell_totel(stock) - this.purchase_total(stock);
						// console.log(stock['stock_info']['stock_num']);
						if(do_sum){
							var stock_num = stock['stock_info']['stock_num'] + '-' +  stock['stock_info']['stock_name'];
							if(typeof owned_stock_master.earn_total_by_stock[stock_num] == 'undefined'){
								owned_stock_master.earn_total_by_stock[stock_num] = 0;
								owned_stock_master.earn_base_by_stock[stock_num] = 0;
							}
							owned_stock_master.earn_total += amount;
							if(amount > 0) owned_stock_master.earn_total_pos += amount;
							else owned_stock_master.earn_total_neg += amount;
							owned_stock_master.earn_total_by_stock[stock_num] += amount;
							owned_stock_master.earn_base_by_stock[stock_num] += parseFloat(this.purchase_total(stock));
						}
						return amount.toFixed(2);
					},
					earn_class: function(stock){
						var val = this.earn(stock, false);
						if(val > 0){ return "green"; }
						else if(val < 0){ return "red"; }
						else return "";
					},
					get_earn_total: function(){
						return owned_stock_master.earn_total_pos.toFixed(2) + " " +
						owned_stock_master.earn_total_neg.toFixed(2) + " = " +
						owned_stock_master.earn_total.toFixed(2);
					},
					get_earn_total_by_stock: function(){
						// return owned_stock_master.earn_total_by_stock;
						var list = owned_stock_master.earn_total_by_stock;
						let sortable = [];
						for (var key in list) {
						    sortable.push([
						    	key,  // stock num + name
						    	list[key] // earn 
						    	, owned_stock_master.earn_base_by_stock[key] // purchase amt
						    ]);
						}

						sortable.sort(function(a, b) {
						    return b[1] - a[1];
						});

						var total_row = ['Total', 0, 0]; // prepare the total row
						sortable.forEach((row) => {
							total_row[1] += row[1];
							total_row[2] += row[2];
						})
						sortable.push(total_row);
						return sortable;
					}
				}
			});
		},
		refreshVue: function(){
			this.earn_total = 0;
			this.earn_total_by_stock = {};
			this.earn_base_by_stock = {};
			this.owned_stock_vue.program = this.owned_stock_data;
		},
		loadData: function(){
			this.earn_total = 0;
			this.earn_total_pos = 0;
			this.earn_total_neg = 0;
			this.earn_total_by_stock = {};
			this.earn_base_by_stock = {};
			var owned_stock = stock_master.stock_setting['owned_stock'].map((x) => x);
			// if(this.is_sort == "True"){
			// 	owned_stock.sort((a,b) => {
			// 		if(a['stock_num'] < b['stock_num']) return -1;
			// 		if(a['stock_num'] > b['stock_num']) return 1;
			// 		return 0;
			// 	});
			// }else if(this.is_sort == "%"){
			// 	owned_stock.sort((a,b) => {
			// 		if(a['stock_num'] < b['stock_num']) return -1;
			// 		if(a['stock_num'] > b['stock_num']) return 1;
			// 		return 0;
			// 	});
			// }
			console.log(owned_stock);
			if(stock_master.stock_setting == null) return; 
			if(stock_master.stock_data_parse == undefined) return; 

			var combine_list = [];
			owned_stock.forEach((stock) => {
				var stock_info = stock_master.getParsedStock(stock['stock_num']);
				// console.log(stock_info);
				stock['stock_info'] = stock_info;
				combine_list.push(stock);
			});
			console.log(combine_list);
			this.owned_stock_data = combine_list;
			if(this.owned_stock_vue == null) this.initVue();
			this.refreshVue();
		},
		calculate_charge_breakdown: function(amount){
			var charge = [];
			var temp = 0;

			// https://www.sc.com/hk/zh/investment/securities-services/hong-kong-securities-services/


			// 結算費（由香港中央結算有限公司收取）
			// 每張中央結算系統股票須按成交金額繳付 0.002% 交收費用，最低收費港幣2元，最高收費港幣100元
			temp = amount *  (0.002/100)
			temp = temp.toFixed(2);
			if(temp < 2) temp = 2;
			charge.push(temp);

			// 交易費（由香港交易所收取）
			// 每宗交易須按成交金額繳付 0.005%
			// NOTED: According to my observe, the actual value should be closed to 0.0565%
			temp = amount *  (0.00565/100)
			temp = temp.toFixed(2);
			charge.push(temp);

			// 證監會交易徵費（由證監會收取）
			// 每宗交易須按成交金額繳付 0.0027%
			temp = amount *  (0.0027/100)
			temp = temp.toFixed(2);
			charge.push(temp);


			// 財匯局交易徵費 (2022年1月1日起生效，由財務匯報局收取)
			// 每宗交易須按成交金額繳付0.00015%
			temp = amount *  (0.00015/100)
			temp = temp.toFixed(2);
			charge.push(temp);


			// 印花稅（由香港政府收取）
			// 每宗交易須按成交金額繳付 0.1%，而不足 港幣1元之數亦須當作港幣1元計
			temp = amount *  (0.1/100)
			temp = Math.ceil(temp);
			if(temp < 1) temp = 1;
			charge.push(temp);

			// 股票佣金
			// 網上銀行及 SC Equities: 0.20% (最低佣金收費為港幣50元)
			temp = amount *  (0.20/100);
			if(temp < 50) temp = 50;
			temp = temp.toFixed(2);
			charge.push(temp);

			// console.log(amount);
			// console.log(charge);
			// return 0;
			return charge;
		},
		calculate_charge: function(amount) {
			var charge = owned_stock_master.calculate_charge_breakdown(amount);
			var output = 0;
			charge.forEach((c) => {
				output += parseFloat(c);
			})

			return parseFloat(output.toFixed(2));
		},
		purchase_total: function(stock){
			var amount = stock['purchase_qty'] * stock['purchase_price'];
			amount += owned_stock_master.calculate_charge(amount);
			return amount.toFixed(2);
		},
		sell_totel: function(stock){
			var amount = stock['purchase_qty'] * stock['stock_info']['current'];
			amount -= owned_stock_master.calculate_charge(amount);
			return amount.toFixed(2);
		},
		earn: function(stock){
			var amount = this.sell_totel(stock) - this.purchase_total(stock)
			return amount.toFixed(2);
		},
		all_earn: function(){
			var data = this.owned_stock_data;
		}
	}

	// owned_stock_master.init();

	function getManager(){
		// getHSI();
		if(general_manager.mode == "start"){
			hsi_master.loadData();
			stock_master.loadData();
			owned_stock_master.loadData();
		}
		setTimeout(getManager, 4 * 1000);
	}

	function init(){
		stock_master.init();
		getManager();
	}
	init();

</script>



<style>
.green{ color: green }
.red{ color: red }

.middle{ text-align: center } 
.right{ text-align: right; padding-right: 20px}

.stock_name{ width: 150px }
.current{ width: 100px }

.align_right{ text-align: right }

.hide{ display: none; }

@media only screen and (max-width: 1200px) {

	#hsi_block, #summary_short{
		font-size: 40px;
		margin-bottom: 30px;
	}


	#owned_stock_block #summary #wrapper {
		width: 100%;
		font-size: 22px;
		gap: 0px 20px;
	}
	#owned_stock_block #summary div#column{
		text-align: right;
	}
	#owned_stock_block #summary div#column:nth-child(1) 
		{ flex: 3; text-align: left;}

	#custom_calculator_input_block, #custom_calculator_output_block{
		display:none;
	}
}
</style>


<!--
		{"stock_num":"257","purchase_price":"3.5","purchase_qty":"10000","actual_pay":"35120.98"}	,
		{"stock_num":"303","purchase_price":"51.8","purchase_qty":"500","actual_pay":"25990"}	,
		{"stock_num":"303","purchase_price":"51.8","purchase_qty":"700","actual_pay":"36385.6"}	,
		{"stock_num":"303","purchase_price":"51.8","purchase_qty":"700","actual_pay":"36385.6"}	,
		{"stock_num":"303","purchase_price":"51.8","purchase_qty":"1000","actual_pay":"51978.01"}	,
		{"stock_num":"303","purchase_price":"51.95","purchase_qty":"3000","actual_pay":"156381.07"}	,
		{"stock_num":"303","purchase_price":"52.1","purchase_qty":"2100","actual_pay":"109783.3"}	,
		{"stock_num":"1313","purchase_price":"4.59","purchase_qty":"20000","actual_pay":"92113.41"}	,
		{"stock_num":"1313","purchase_price":"4.59","purchase_qty":"12000","actual_pay":"55268.84"}	,
		{"stock_num":"1313","purchase_price":"4.58","purchase_qty":"12000","actual_pay":"55148.59"}	,
		{"stock_num":"257","purchase_price":"3.5","purchase_qty":"30000","actual_pay":"105385.03"}	,
		{"stock_num":"1313","purchase_price":"4.51","purchase_qty":"16000","actual_pay":"72406.46"}	,
		{"stock_num":"257","purchase_price":"3.45","purchase_qty":"20000","actual_pay":"69235.86"}	,
		{"stock_num":"303","purchase_price":"50.2","purchase_qty":"1500","actual_pay":"75556.99"}	,
		{"stock_num":"1088","purchase_price":"23.35","purchase_qty":"3000","actual_pay":"70290.06"}	,
		{"stock_num":"17","purchase_price":"22.4","purchase_qty":"4000","actual_pay":"89905.81"}	,
		{"stock_num":"17","purchase_price":"22.15","purchase_qty":"4000","actual_pay":"88902.73"}	,
		{"stock_num":"2638","purchase_price":"5.04","purchase_qty":"10000","actual_pay":"50573.09"}	,
		{"stock_num":"868","purchase_price":"15.26","purchase_qty":"3000","actual_pay":"45937.46"}	,
		{"stock_num":"257","purchase_price":"3.32","purchase_qty":"15000","actual_pay":"49970.82"}	,
		{"stock_num":"303","purchase_price":"49.25","purchase_qty":"2100","actual_pay":"103777.71"}
-->